# 機能設計書 109-API Resources表示

## 概要

本ドキュメントは、`kubectl api-resources` および `kubectl api-versions` コマンドによるAPI情報表示機能の設計を記述する。クラスターがサポートするAPIリソースとバージョンの一覧を表示する。

### 本機能の処理概要

**業務上の目的・背景**：Kubernetesクラスターは動的にAPIリソースを拡張可能（CRD、Aggregated API等）であり、利用可能なリソースタイプやAPIバージョンはクラスターごとに異なる。`kubectl api-resources` と `kubectl api-versions` は現在のクラスターがサポートするリソースとバージョンを確認する手段を提供する。

**機能の利用シーン**：CRD登録後の確認、APIバージョンのマイグレーション確認、リソースの短縮名やスコープ（Namespaced/Cluster）の確認、特定バーブをサポートするリソースの絞り込み等に利用される。

**主要な処理内容**：
1. `api-resources`: Discovery APIからリソース一覧を取得しフィルタ・ソート表示
2. `api-versions`: Discovery APIからAPIバージョン一覧を取得しソート表示

**関連システム・外部連携**：Discovery API

**権限による制御**：Discovery APIへのアクセス権限が必要（通常は全ユーザーに付与）

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 32 | kubectl api-resources | 主機能 | サポートされるAPIリソース一覧表示 |
| 32 | kubectl api-versions | 主機能 | サポートされるAPIバージョン一覧表示 |

## 機能種別

情報表示・API探索

## 入力仕様

### 入力パラメータ（api-resources）

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| --api-group | string | No | APIグループでフィルタ | |
| --namespaced | bool | No | Namespacedスコープでフィルタ | デフォルト: true |
| --verbs | string[] | No | サポートするバーブでフィルタ | |
| --sort-by | string | No | ソートキー | name / kind のみ |
| --cached | bool | No | キャッシュ利用 | デフォルト: false |
| --categories | string[] | No | カテゴリでフィルタ | |
| -o / --output | string | No | 出力形式 | "" / wide |
| --no-headers | bool | No | ヘッダー非表示 | |

### 入力パラメータ（api-versions）

引数なし。

### 入力データソース

- Discovery API（ServerPreferredResources / ServerGroups）

## 出力仕様

### 出力データ（api-resources）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| NAME | string | リソース名 |
| SHORTNAMES | string | 短縮名 |
| APIVERSION | string | APIバージョン（group/version） |
| NAMESPACED | bool | Namespacedスコープか |
| KIND | string | Kind名 |
| VERBS | string[] | サポートバーブ（wide出力時） |
| CATEGORIES | string[] | カテゴリ（wide出力時） |

### 出力データ（api-versions）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| APIバージョン | string | group/version 形式のバージョン文字列 |

### 出力先

標準出力（stdout）にテーブル形式（api-resources）またはリスト形式（api-versions）で表示

## 処理フロー

### 処理シーケンス（api-resources）

```
1. 引数パースとバリデーション
   └─ --sort-by は name/kind のみ
2. Discovery Client初期化
3. キャッシュ制御
   └─ --cached=false: discoveryClient.Invalidate()で新鮮なデータ要求
4. ServerPreferredResources()でリソース一覧取得
5. 各リソースに対するフィルタリング
   ├─ Verbs空のリソースを除外
   ├─ --api-group によるグループフィルタ
   ├─ --namespaced によるスコープフィルタ
   ├─ --verbs による対応バーブフィルタ
   └─ --categories によるカテゴリフィルタ
6. ソート
   └─ sortableResource によるソート（デフォルト: グループ名 -> リソース名）
7. テーブル表示
```

### 処理シーケンス（api-versions）

```
1. Discovery Client初期化
2. discoveryClient.Invalidate()で新鮮なデータ要求
3. ServerGroups()でグループ一覧取得
4. ExtractGroupVersions()でバージョン文字列抽出
5. ソート
6. 行ごとに出力
```

### フローチャート

```mermaid
flowchart TD
    A[開始 api-resources] --> B[Discovery Client初期化]
    B --> C{--cached?}
    C -->|No| D[Invalidate - 新鮮なデータ要求]
    C -->|Yes| E[キャッシュ利用]
    D --> F[ServerPreferredResources]
    E --> F
    F --> G{各リソースをフィルタ}
    G --> H[--api-group フィルタ]
    H --> I[--namespaced フィルタ]
    I --> J[--verbs フィルタ]
    J --> K[--categories フィルタ]
    K --> L[ソート]
    L --> M[テーブル表示]
    M --> N[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-901 | キャッシュ制御 | デフォルトは常にサーバーから最新データを取得（Invalidate） | --cached=false（デフォルト） |
| BR-902 | ソートキー | name: リソース名、kind: Kind名、デフォルト: グループ名 -> リソース名 | api-resources |
| BR-903 | Verbs空除外 | Verbsが空のリソースはリストから除外 | api-resources |
| BR-904 | api-versions ソート | 文字列のアルファベット順ソート | api-versions |
| BR-905 | フラグ変更検出 | --api-group / --namespaced はフラグが明示的に指定された場合のみフィルタ | api-resources |
| BR-906 | wide出力 | VERBSとCATEGORIESカラムを追加表示 | -o wide 指定時 |

### 計算ロジック

sortableResource: --sort-by=name のときはリソース名、--sort-by=kind のときはKind名で比較。同値の場合はリソース名でセカンダリソート。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| リソース一覧 | Discovery API | SELECT | ServerPreferredResources |
| バージョン一覧 | Discovery API | SELECT | ServerGroups |

### テーブル別操作詳細

読み取り専用。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | バリデーション | --sort-byに不正な値 | "--sort-by accepts only name or kind" |
| - | 引数エラー | 不要な引数が指定された | "unexpected arguments" |
| - | Discovery失敗 | APIグループの取得失敗 | "couldn't get available api versions from server" |

### リトライ仕様

特にリトライ処理は実装されていない。

## トランザクション仕様

読み取り専用の参照処理であり、トランザクション管理は不要。

## パフォーマンス要件

Discovery APIはCachedDiscoveryInterfaceを使用する。--cachedフラグでキャッシュ利用を制御可能。

## セキュリティ考慮事項

- Discovery APIへのアクセスは通常全ユーザーに許可されているが、制限されている場合は利用できない
- APIリソース情報自体にセキュリティ上の機密性はないが、クラスター構成情報として扱うべき

## 備考

- api-resources は Preferred Versions のみ表示する（同一リソースの複数バージョンは最優先バージョンのみ）
- Discovery APIのエラーは部分的な結果を返す場合がある（一部グループのみエラー）

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | APIResourceOptions構造体（64-80行目） |
| 1-2 | apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | APIVersionsOptions構造体（41-45行目） |
| 1-3 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | sortableResource構造体（263-290行目）：ソートロジック |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | NewCmdAPIResources関数（92-116行目） |
| 2-2 | apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | NewCmdAPIVersions関数（55-69行目） |

#### Step 3: api-resources処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | Complete関数（130-167行目）：Discovery Client初期化とフラグ変更検出 |
| 3-2 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | RunAPIResources関数（170-252行目）：メイン処理 |
| 3-3 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | **174-177行目**: キャッシュ制御（Invalidate） |
| 3-4 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | **203-227行目**: 各種フィルタリング処理 |
| 3-5 | apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | **245行目**: ソート処理 |

#### Step 4: api-versions処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | RunAPIVersions関数（82-96行目）：ServerGroups + ソート + 出力 |

### プログラム呼び出し階層図

```
[api-resources]
NewCmdAPIResources
    ├─ APIResourceOptions.Complete()
    │      ├─ ToDiscoveryClient()
    │      └─ cmd.Flags().Changed() [フラグ変更検出]
    ├─ APIResourceOptions.Validate()
    └─ APIResourceOptions.RunAPIResources()
           ├─ discoveryClient.Invalidate() [--cached=false時]
           ├─ discoveryClient.ServerPreferredResources()
           ├─ フィルタリング（group/namespaced/verbs/categories）
           ├─ sort.Stable(sortableResource{})
           └─ PrintObj()

[api-versions]
NewCmdAPIVersions
    ├─ APIVersionsOptions.Complete()
    │      └─ ToDiscoveryClient()
    └─ APIVersionsOptions.RunAPIVersions()
           ├─ discoveryClient.Invalidate()
           ├─ discoveryClient.ServerGroups()
           ├─ metav1.ExtractGroupVersions()
           ├─ sort.Strings()
           └─ fmt.Fprintln() [各バージョン出力]
```

### データフロー図

```
[api-resources]
Discovery API ──▶ ServerPreferredResources ──▶ フィルタ ──▶ ソート ──▶ テーブル ──▶ stdout

[api-versions]
Discovery API ──▶ ServerGroups ──▶ ExtractGroupVersions ──▶ ソート ──▶ リスト ──▶ stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| apiresources.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources.go` | ソース | api-resourcesコマンド |
| apiversions.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiversions.go` | ソース | api-versionsコマンド |
| apiresources_test.go | `staging/src/k8s.io/kubectl/pkg/cmd/apiresources/apiresources_test.go` | テスト | テスト |
